/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Random;

public final class CaveNetworkGenerator {
    private static boolean use_optimized_code = true;
    private final CaveNetworkStub stub;
    private final int size_x;
    private final int size_z;
    private final int size_y;
    private final int volume;
    private final byte[] cells;
    private final byte[] cells_copy;
    private final byte[] wall_mask;
    private final Random rand;
    private final int size_xz;
    private static final int CELL_AIR = 0;
    private static final int CELL_WALL = 1;
    private final boolean has_mycelium;
    private boolean has_raised_shell_floor;

    public CaveNetworkGenerator(CaveNetworkStub stub) {
        this.stub = stub;
        this.size_x = stub.getSizeX();
        this.size_y = stub.getSizeY();
        this.size_z = stub.getSizeZ();
        this.volume = this.size_x * this.size_y * this.size_z;
        this.cells = new byte[this.volume];
        this.cells_copy = new byte[this.cells.length];
        this.wall_mask = new byte[this.cells.length];
        if (stub.hasLegacySeed()) {
            this.rand = new Random(stub.getLegacySeed());
            this.rand.nextInt(200);
            this.rand.nextInt(2);
            this.rand.nextLong();
        } else {
            this.rand = new Random(stub.getSeed());
            this.rand.nextInt();
        }
        this.size_xz = this.size_x * this.size_z;
        this.has_mycelium = stub.hasMycelium();
        this.generate();
    }

    public int getOriginChunkX() {
        return this.stub.getOriginChunkX();
    }

    public int getOriginChunkZ() {
        return this.stub.getOriginChunkZ();
    }

    public void fill(int value) {
        Arrays.fill(this.cells, (byte)value);
    }

    public void fill(int value, float percentage) {
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (!(this.rand.nextFloat() < percentage)) continue;
            this.cells[i2] = (byte)value;
        }
    }

    private void fillRandomSubVolumeWithBias(float bias, float min_volume_fraction, float max_volume_fraction) {
        int sub_size_z;
        int sub_size_y;
        int sub_size_x;
        float volume_fraction;
        while ((volume_fraction = (float)((sub_size_x = this.rand.nextInt(this.size_x) + 1) * (sub_size_y = this.rand.nextInt(this.size_y) + 1) * (sub_size_z = this.rand.nextInt(this.size_z) + 1)) / (float)this.volume) < min_volume_fraction || volume_fraction > max_volume_fraction) {
        }
        int x2 = this.rand.nextBoolean() ? 0 : this.size_x - sub_size_x;
        int y2 = this.rand.nextBoolean() ? 0 : this.size_y - sub_size_y;
        int z2 = this.rand.nextBoolean() ? 0 : this.size_z - sub_size_z;
        for (int dx2 = 0; dx2 < sub_size_x; ++dx2) {
            for (int dz2 = 0; dz2 < sub_size_z; ++dz2) {
                for (int dy2 = 0; dy2 < sub_size_y; ++dy2) {
                    this.setValueAt(x2 + dx2, y2 + dy2, z2 + dz2, this.rand.nextFloat() < bias ? 0 : 1);
                }
            }
        }
    }

    private void fillBottomHalfWithAirBias() {
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        float bias = 0.51f + this.rand.nextFloat() * 0.01f;
        for (int dx2 = 0; dx2 < this.size_x; ++dx2) {
            for (int dz2 = 0; dz2 < this.size_z; ++dz2) {
                for (int dy2 = 0; dy2 < this.size_y / 2; ++dy2) {
                    this.setValueAt(x2 + dx2, y2 + dy2, z2 + dz2, this.rand.nextFloat() < bias ? 0 : 1);
                }
            }
        }
    }

    private void raiseFloor() {
        int amount = this.rand.nextInt(this.size_y / 2 + 1);
        for (int x2 = 0; x2 < this.size_x; ++x2) {
            for (int z2 = 0; z2 < this.size_z; ++z2) {
                for (int y2 = 0; y2 < amount; ++y2) {
                    this.setValueAt(x2, y2, z2, this.rand.nextFloat() < 0.47f ? 0 : 1);
                }
            }
        }
    }

    private void lowerCeiling() {
        int amount = this.rand.nextInt(this.size_y / 2 + 1);
        for (int x2 = 0; x2 < this.size_x; ++x2) {
            for (int z2 = 0; z2 < this.size_z; ++z2) {
                for (int y2 = this.size_y - amount; y2 < this.size_y; ++y2) {
                    this.setValueAt(x2, y2, z2, this.rand.nextFloat() < 0.47f ? 0 : 1);
                }
            }
        }
    }

    public void generateInterior(int smoothening) {
        this.fill(1);
        this.fill(0, 0.5f);
        if (!this.stub.hasLegacySeed() && this.rand.nextBoolean()) {
            this.fillRandomSubVolumeWithBias(0.51f, 0.0f, 0.5f);
        }
        if (!this.stub.hasLegacySeed() && this.rand.nextBoolean()) {
            this.fillRandomSubVolumeWithBias(0.49f, 0.0f, 0.5f);
        }
        if (this.has_mycelium) {
            if (!this.stub.hasLegacySeed() && this.rand.nextBoolean()) {
                this.lowerCeiling();
            }
            this.fillBottomHalfWithAirBias();
        } else {
            if (this.rand.nextBoolean()) {
                this.fillRandomSubVolumeWithBias(0.48f, 0.0f, 0.5f);
            }
            if (this.rand.nextFloat() < 0.8f) {
                if (this.rand.nextBoolean()) {
                    this.raiseFloor();
                } else {
                    this.lowerCeiling();
                }
            } else if (this.rand.nextBoolean()) {
                this.fillBottomHalfWithAirBias();
            }
        }
        this.smoothen(smoothening);
    }

    private void excavate(int iterations) {
        if (use_optimized_code) {
            this.excavate_optimized(iterations);
            return;
        }
        for (int i2 = 0; i2 < iterations; ++i2) {
            System.arraycopy(this.cells, 0, this.cells_copy, 0, this.cells.length);
            for (int x2 = 1; x2 < this.size_x - 1; ++x2) {
                for (int z2 = 1; z2 < this.size_z - 1; ++z2) {
                    for (int y2 = 1; y2 < this.size_y - 1; ++y2) {
                        if (this.cells_copy[this.getIndex(x2, y2, z2)] != 0) continue;
                        int ran = this.rand.nextInt(6);
                        if (ran == 0) {
                            this.setValueAt(x2, y2 - 1, z2, 0);
                            continue;
                        }
                        if (ran == 1) {
                            this.setValueAt(x2, y2 + 1, z2, 0);
                            continue;
                        }
                        if (ran == 2) {
                            this.setValueAt(x2 - 1, y2, z2, 0);
                            continue;
                        }
                        if (ran == 3) {
                            this.setValueAt(x2 + 1, y2, z2, 0);
                            continue;
                        }
                        if (ran == 4) {
                            this.setValueAt(x2, y2, z2 - 1, 0);
                            continue;
                        }
                        this.setValueAt(x2, y2, z2 + 1, 0);
                    }
                }
            }
        }
    }

    private void excavate_optimized(int iterations) {
        for (int i2 = 0; i2 < iterations; ++i2) {
            System.arraycopy(this.cells, 0, this.cells_copy, 0, this.cells.length);
            for (int x2 = 1; x2 < this.size_x - 1; ++x2) {
                for (int z2 = 1; z2 < this.size_z - 1; ++z2) {
                    for (int y2 = 1; y2 < this.size_y - 1; ++y2) {
                        int index = x2 + z2 * this.size_x + y2 * this.size_xz;
                        if (this.cells_copy[index] != 0) continue;
                        int ran = this.rand.nextInt(6);
                        if (ran == 0) {
                            this.cells[index - this.size_xz] = 0;
                            continue;
                        }
                        if (ran == 1) {
                            this.cells[index + this.size_xz] = 0;
                            continue;
                        }
                        if (ran == 2) {
                            this.cells[index - 1] = 0;
                            continue;
                        }
                        if (ran == 3) {
                            this.cells[index + 1] = 0;
                            continue;
                        }
                        if (ran == 4) {
                            this.cells[index - this.size_x] = 0;
                            continue;
                        }
                        this.cells[index + this.size_x] = 0;
                    }
                }
            }
        }
    }

    public void generateShell(int smoothening) {
        this.fill(1);
        float center_x = (float)this.size_x * 0.5f;
        float center_y = (float)this.size_y * 0.5f;
        float center_z = (float)this.size_z * 0.5f;
        this.has_raised_shell_floor = this.has_mycelium || this.rand.nextBoolean();
        for (int x2 = 16; x2 < this.size_x - 16; ++x2) {
            for (int z2 = 16; z2 < this.size_z - 16; ++z2) {
                int y2;
                int n2 = y2 = this.has_raised_shell_floor ? 24 : 16;
                while (y2 < this.size_y - 16) {
                    float dx2 = (float)x2 + 0.5f - center_x;
                    float dz2 = (float)z2 + 0.5f - center_z;
                    if (!(dx2 * dx2 + dz2 * dz2 > 256.0f)) {
                        this.setValueAt(x2, y2, z2, 0);
                    }
                    ++y2;
                }
            }
        }
        this.excavate(Math.max(this.size_x / 2, Math.max(this.size_z / 2, this.size_y / 2)));
        this.smoothen(smoothening);
        System.arraycopy(this.cells, 0, this.wall_mask, 0, this.cells.length);
    }

    public int getIndex(int x2, int y2, int z2) {
        return x2 + (z2 << 6) + (y2 << 12);
    }

    public void setValueAt(int x2, int y2, int z2, int value) {
        this.cells[this.getIndex((int)x2, (int)y2, (int)z2)] = (byte)value;
    }

    public byte getValueAt(int x2, int y2, int z2) {
        return this.cells[this.getIndex(x2, y2, z2)];
    }

    public byte getValueAt(byte[] cells, int x2, int y2, int z2) {
        return cells[this.getIndex(x2, y2, z2)];
    }

    public void smoothen() {
        if (use_optimized_code) {
            this.smoothen_optimized();
            return;
        }
        System.arraycopy(this.cells, 0, this.cells_copy, 0, this.cells.length);
        for (int x2 = 1; x2 < this.size_x - 1; ++x2) {
            for (int z2 = 1; z2 < this.size_z - 1; ++z2) {
                for (int y2 = 1; y2 < this.size_y - 1; ++y2) {
                    byte wall_value = this.getValueAt(this.cells_copy, x2, y2, z2);
                    if (wall_value == 0) {
                        wall_value = 1;
                    }
                    int num_walls = 0;
                    for (int dx2 = -1; dx2 <= 1 && num_walls < 14; ++dx2) {
                        for (int dz2 = -1; dz2 <= 1 && num_walls < 14; ++dz2) {
                            for (int dy2 = -1; dy2 <= 1 && num_walls < 14; ++dy2) {
                                if (this.getValueAt(this.cells_copy, x2 + dx2, y2 + dy2, z2 + dz2) == 0) continue;
                                ++num_walls;
                            }
                        }
                    }
                    this.setValueAt(x2, y2, z2, num_walls < 14 ? (byte)0 : wall_value);
                }
            }
        }
    }

    public void smoothen_optimized() {
        System.arraycopy(this.cells, 0, this.cells_copy, 0, this.cells.length);
        int[] index_deltas = new int[27];
        int index_deltas_index = -1;
        for (int dx2 = -1; dx2 <= 1; ++dx2) {
            for (int dz2 = -1; dz2 <= 1; ++dz2) {
                for (int dy2 = -1; dy2 <= 1; ++dy2) {
                    index_deltas[++index_deltas_index] = dx2 + dz2 * this.size_x + dy2 * this.size_xz;
                }
            }
        }
        for (int y2 = 1; y2 < this.size_y - 1; ++y2) {
            int index = y2 * this.size_xz;
            for (int z2 = 1; z2 < this.size_z - 1; ++z2) {
                index += this.size_x;
                for (int x2 = 1; x2 < this.size_x - 1; ++x2) {
                    byte wall_value;
                    if ((wall_value = this.cells_copy[++index]) == 0) {
                        wall_value = 1;
                    }
                    int num_walls = 0;
                    for (int i2 = 0; i2 < index_deltas.length && (this.cells_copy[index + index_deltas[i2]] == 0 || ++num_walls <= 13); ++i2) {
                    }
                    this.cells[index] = num_walls < 14 ? (byte)0 : wall_value;
                }
                index -= this.size_x - 2;
            }
        }
    }

    public void smoothen(int num_iterations) {
        while (--num_iterations >= 0) {
            this.smoothen();
        }
    }

    public void applyWallMask(int smoothening) {
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.wall_mask[i2] == 0) continue;
            this.cells[i2] = this.wall_mask[i2];
        }
        this.smoothen(smoothening);
    }

    private void removePockmarks() {
        int y2;
        int index;
        int x2;
        for (x2 = 0; x2 < this.size_x; ++x2) {
            for (int z2 = 0; z2 < this.size_z; ++z2) {
                index = this.getIndex(x2, 0, z2);
                if (this.cells[index] == 0 && this.cells[index + this.size_xz] != 0) {
                    this.cells[index] = 1;
                }
                if (this.cells[index = this.getIndex(x2, this.size_y - 1, z2)] != 0 || this.cells[index - this.size_xz] == 0) continue;
                this.cells[index] = 1;
            }
        }
        for (x2 = 0; x2 < this.size_x; ++x2) {
            for (y2 = 0; y2 < this.size_y; ++y2) {
                index = this.getIndex(x2, y2, 0);
                if (this.cells[index] == 0 && this.cells[index + this.size_x] != 0) {
                    this.cells[index] = 1;
                }
                if (this.cells[index = this.getIndex(x2, y2, this.size_z - 1)] != 0 || this.cells[index - this.size_x] == 0) continue;
                this.cells[index] = 1;
            }
        }
        for (int z3 = 0; z3 < this.size_z; ++z3) {
            for (y2 = 0; y2 < this.size_y; ++y2) {
                index = this.getIndex(0, y2, z3);
                if (this.cells[index] == 0 && this.cells[index + 1] != 0) {
                    this.cells[index] = 1;
                }
                if (this.cells[index = this.getIndex(this.size_x - 1, y2, z3)] != 0 || this.cells[index - 1] == 0) continue;
                this.cells[index] = 1;
            }
        }
    }

    private void generate() {
        int[] smoothening = new int[3];
        int ran = this.rand.nextInt(3);
        if (ran == 0) {
            smoothening[0] = 2;
            smoothening[1] = this.rand.nextInt(57) + 8;
            smoothening[2] = 2 - smoothening[0];
        } else if (ran == 1) {
            smoothening[0] = this.rand.nextInt(3);
            int total_smoothening = this.rand.nextInt(57) + 8;
            smoothening[1] = this.rand.nextInt(total_smoothening + 1);
            smoothening[2] = total_smoothening - smoothening[1];
            if (smoothening[0] + smoothening[2] < 2) {
                smoothening[1] = smoothening[1] - 2;
                smoothening[2] = smoothening[2] + 2;
            }
        } else {
            smoothening[0] = 0;
            smoothening[1] = 0;
            smoothening[2] = this.rand.nextInt(57) + 8;
        }
        this.generateShell(smoothening[0]);
        this.generateInterior(smoothening[1]);
        this.applyWallMask(smoothening[2]);
        this.removePockmarks();
        Debug.println("generateCaveNetwork: " + this.stub);
    }

    public void apply(abw world, int x2, int y2, int z2) {
        if (this.has_mycelium) {
            int dy2;
            int dz2;
            int dx2;
            int lowest_air_cell = Integer.MAX_VALUE;
            for (dx2 = 0; dx2 < this.size_x; ++dx2) {
                for (dz2 = 0; dz2 < this.size_z; ++dz2) {
                    for (dy2 = 0; dy2 < this.size_y; ++dy2) {
                        byte value = this.getValueAt(dx2, dy2, dz2);
                        world.c(x2 + dx2, y2 + dy2, z2 + dz2, value);
                        if (value != 0 || dy2 >= lowest_air_cell) continue;
                        lowest_air_cell = dy2;
                    }
                }
            }
            for (dx2 = 0; dx2 < this.size_x; ++dx2) {
                for (dz2 = 0; dz2 < this.size_z; ++dz2) {
                    for (dy2 = Math.max(lowest_air_cell, 1); dy2 < Math.min(lowest_air_cell + 6, this.size_y - 1); ++dy2) {
                        if (this.getValueAt(dx2, dy2, dz2) != 0 || this.getValueAt(dx2, dy2 - 1, dz2) != 1) continue;
                        world.c(x2 + dx2, y2 + dy2, z2 + dz2, world.c(x2 + dx2, y2 + dy2 + 1, z2 + dz2) ? aqz.bD.cF : aqz.y.cF);
                    }
                }
            }
        } else {
            for (int dx3 = 0; dx3 < this.size_x; ++dx3) {
                for (int dz3 = 0; dz3 < this.size_z; ++dz3) {
                    for (int dy3 = 0; dy3 < this.size_y; ++dy3) {
                        world.c(x2 + dx3, y2 + dy3, z2 + dz3, this.getValueAt(dx3, dy3, dz3));
                    }
                }
            }
        }
    }

    private void replaceBlockAboveIfUnstable(int local_x, int y2, int local_z, byte[] block_ids) {
        aqz block;
        byte block_above_id = block_ids[(local_x * 16 + local_z) * 128 + y2 + 1];
        if (block_above_id > 0 && (block = aqz.getBlock(block_above_id)) instanceof BlockFalling) {
            block_ids[(local_x * 16 + local_z) * 128 + y2 + 1] = block_ids[(local_x * 16 + local_z) * 128 + y2 + 2] == aqz.G.cF ? (byte)aqz.bb.cF : (byte)(block == aqz.J ? aqz.V.cF : aqz.y.cF);
        }
    }

    public void apply(int chunk_x, int chunk_z, int origin_chunk_x, int origin_chunk_z, byte[] block_ids) {
        int y2;
        int local_z;
        int local_x;
        int shift_x = (chunk_x - origin_chunk_x) * 16;
        int shift_z = (chunk_z - origin_chunk_z) * 16;
        if (this.has_mycelium) {
            int cell_y;
            int local_z2;
            int local_x2;
            int lowest_air_cell = this.size_y;
            for (local_x2 = 0; local_x2 < 16; ++local_x2) {
                for (local_z2 = 0; local_z2 < 16; ++local_z2) {
                    for (cell_y = 0; cell_y < this.size_y; ++cell_y) {
                        byte value = this.getValueAt(shift_x + local_x2, cell_y, shift_z + local_z2);
                        if (value != 0) continue;
                        block_ids[(local_x2 * 16 + local_z2) * 128 + cell_y + 8] = 0;
                        if (cell_y >= lowest_air_cell) continue;
                        lowest_air_cell = cell_y;
                    }
                }
            }
            for (int x2 = 0; x2 < this.size_x; ++x2) {
                block4: for (int z2 = 0; z2 < this.size_z; ++z2) {
                    for (int y3 = 0; y3 < lowest_air_cell; ++y3) {
                        if (this.getValueAt(x2, y3, z2) != 0) continue;
                        lowest_air_cell = y3;
                        continue block4;
                    }
                }
            }
            for (local_x2 = 0; local_x2 < 16; ++local_x2) {
                for (local_z2 = 0; local_z2 < 16; ++local_z2) {
                    for (cell_y = Math.max(lowest_air_cell, 1); cell_y < Math.min(lowest_air_cell + 6, this.size_y - 1); ++cell_y) {
                        if (this.getValueAt(shift_x + local_x2, cell_y, shift_z + local_z2) != 0 || this.getValueAt(shift_x + local_x2, cell_y - 1, shift_z + local_z2) != 1) continue;
                        block_ids[(local_x2 * 16 + local_z2) * 128 + cell_y + 8] = (byte)(block_ids[(local_x2 * 16 + local_z2) * 128 + cell_y + 8 + 1] == 0 ? aqz.bD.cF : aqz.y.cF);
                        block_ids[(local_x2 * 16 + local_z2) * 128 + cell_y + 8 - 1] = (byte)aqz.y.cF;
                    }
                }
            }
        } else {
            for (local_x = 0; local_x < 16; ++local_x) {
                for (local_z = 0; local_z < 16; ++local_z) {
                    for (y2 = 8; y2 < 8 + this.size_y; ++y2) {
                        if (this.getValueAt(shift_x + local_x, y2 - 8, shift_z + local_z) != 0) continue;
                        block_ids[(local_x * 16 + local_z) * 128 + y2] = 0;
                    }
                }
            }
        }
        for (local_x = 0; local_x < 16; ++local_x) {
            block13: for (local_z = 0; local_z < 16; ++local_z) {
                for (y2 = 8 + this.size_y - 1; y2 >= 8; --y2) {
                    if (this.getValueAt(shift_x + local_x, y2 - 8, shift_z + local_z) != 0) continue;
                    this.replaceBlockAboveIfUnstable(local_x, y2, local_z, block_ids);
                    continue block13;
                }
            }
        }
    }
}

